/*
 * Decompiled with CFR 0.152.
 */
package panther.pep;

import apicore.ptmp.PTSessionClosedError;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JProgressBar;
import panther.util.general.Constants;
import panther.util.general.NoTricksTimerThread;
import panther.util.general.ProportionalBox;
import panther.util.general.ProportionalLayoutManager;
import panther.util.general.RandomUtils;
import panther.util.general.StringUtils;
import panther.util.general.WatcherThread;
import panther.util.smalltalk.SimpleBlock;
import panther.util.unicon.GuaranteedActionStrict;
import panther.xp.XPassPtsi;
import panther.xp.XPassUnavailableException;
import pse.pt.PacketTracer;
import pse.pt.PacketTracerUtils;
import pse.result.IosLog;
import pse.result.Result;
import pse.result.Session;
import pse.result.SessionStart;
import pse.result.SittingEnd;
import pse.result.SittingStart;
import pse.result.WorkProduct;
import pse.result.WorkProductSummary;
import pse.result.XpassSession;
import pse.util.general.ApplicationError;
import pse.util.general.ErrorUtils;
import skeletonapplet.AbstractDelegatorApplet;
import skeletonapplet.JreDatum;
import skeletonapplet.JreInfo;
import skeletonapplet.PacketTracerLocator;
import skeletonapplet.PtsiApplet;
import skeletonapplet.PtsiAppletWorker;
import skeletonapplet.PtsiStorage;
import skeletonapplet.PtsiWorkerError;
import skeletonapplet.Utilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PtsiWorker
implements PtsiAppletWorker {
    protected PtsiApplet applet;
    protected PacketTracer packetTracer;
    protected NoTricksTimerThread autoSaveTimer;
    protected WatcherThread packetTracerWatcher;
    protected boolean timersOn = false;
    protected XPassPtsi xpass;
    protected Map<String, Result> results = new HashMap<String, Result>();
    protected Map<String, IosLog> iosLogs = new HashMap<String, IosLog>();
    protected boolean packetTracerClosed = false;
    protected String ptaAuthentication;
    protected String ptaLocation;
    protected String[] allowedPtVersions;
    protected String[] disallowedPtVersions;
    protected String[] disallowedBrowserNames;
    protected String[] mediaObjectIds;
    protected String minimumPtVersionSpecific;
    protected int maximumPacketTracerVersionCheckTimeInSeconds = 8;
    protected int maximumPkaLoadTimeInSeconds = 120;
    protected int autoSaveIntervalInMilliseconds = 300000;
    protected boolean exceptionsOff = false;
    protected String myId;
    protected String currentPtItemId;
    protected String mode = "none";
    protected JProgressBar progressBar;
    protected JButton showButton;
    protected JButton hideButton;
    protected String pantherPkaUrlString;
    protected String pantherPreviousAutosaveXmlUrlString;
    protected String reviewSessionId;
    protected boolean isActive = false;
    public static final String HIDE_LABEL_PARAMETER_NAME = "hide-button";
    public static final String RAVENNA_PTMO_GUID = "ravenna";
    public static final String SHOW_LABEL_PARAMETER_NAME = "show-button";

    public PtsiWorker() {
        JreInfo.soleInstance().ptaBuild().setValueOkay("16.003");
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (this.modeRavenna()) {
            if (actionEvent.getSource() == this.hideButton) {
                this.hideButton.setEnabled(false);
                this.unloadPTItem();
                this.showButton.setEnabled(true);
            } else if (actionEvent.getSource() == this.showButton) {
                this.showButton.setEnabled(false);
                this.loadPTItem(RAVENNA_PTMO_GUID);
                this.hideButton.setEnabled(true);
            }
        }
    }

    @Override
    public void destroy() {
        Utilities.logPrintln("\n\n" + this + " DESTROY " + this.myId + " start \n\n");
        this.isActive = false;
        this.timersOn = false;
        this.exceptionsOff = true;
        this.unloadPTItem();
        if (this.packetTracer != null) {
            this.packetTracer.safeDestroyPacketTracerProcess();
        }
        Utilities.logPrintln("\n\n" + this + " DESTROY " + this.myId + " end \n\n");
    }

    @Override
    public String getBuildVersion() {
        return "16.003";
    }

    public String getCurrentResultXml() {
        Result result = this.results.get(RAVENNA_PTMO_GUID);
        IosLog iosLog = this.iosLogs.get(RAVENNA_PTMO_GUID);
        Session session = result.getSession();
        Calendar calendar = Calendar.getInstance();
        SittingEnd sittingEnd = new SittingEnd();
        sittingEnd.setClientTime(calendar);
        sittingEnd.setServerTimeForFillIn();
        IosLog iosLog2 = this.packetTracer.getIosLog(iosLog);
        byte[] byArray = this.packetTracer.extractBytes();
        result.noteAutoSave(byArray, iosLog2, Calendar.getInstance());
        session.addEvent(sittingEnd);
        String string = result.toXmlStringWithDocType();
        result.getWorkProduct().setIosLog(iosLog);
        session.removeEvent(sittingEnd);
        return string;
    }

    @Override
    public Date getLoadDate() {
        return Constants.LOAD_DATE;
    }

    @Override
    public void init() {
        block34: {
            this.myId = String.valueOf(this.hashCode()) + RandomUtils.chooseInt(1001, 9999);
            Utilities.logPrintln("\n\n" + this + " INIT " + this.myId + " start \n\n");
            this.exceptionsOff = false;
            this.isActive = true;
            try {
                Object object;
                Object object2;
                String string;
                String string2;
                String string3 = this.getParameter("mode");
                if (string3 != null && string3.trim().length() > 0) {
                    this.mode = string3.trim();
                }
                if (this.modeRavenna()) {
                    string2 = null;
                    string = null;
                    try {
                        string2 = this.getParameter(HIDE_LABEL_PARAMETER_NAME, null);
                    }
                    catch (Throwable throwable) {
                        pse.util.general.Utilities.check(throwable);
                    }
                    try {
                        string = this.getParameter(SHOW_LABEL_PARAMETER_NAME, null);
                    }
                    catch (Throwable throwable) {
                        pse.util.general.Utilities.check(throwable);
                    }
                    try {
                        this.hideButton = new JButton("Dummy");
                        this.showButton = new JButton("Dummy");
                        this.applet.setLayout(new ProportionalLayoutManager());
                        object2 = new ArrayList();
                        if (string != null && string.trim().length() > 0) {
                            this.showButton = new JButton(string.trim());
                            this.showButton.addActionListener(this);
                            this.showButton.setBorder(BorderFactory.createBevelBorder(0));
                            this.showButton.setEnabled(true);
                            object2.add(this.showButton);
                        }
                        if (string2 != null && string2.trim().length() > 0) {
                            this.hideButton = new JButton(string2.trim());
                            this.hideButton.addActionListener(this);
                            this.hideButton.setBorder(BorderFactory.createBevelBorder(0));
                            this.hideButton.setEnabled(false);
                            object2.add(this.hideButton);
                        }
                        if (object2.size() >= 1) {
                            this.applet.add((Component)object2.get(0), new ProportionalBox(25, 3, 50, 22));
                        }
                        if (object2.size() >= 2) {
                            this.applet.add((Component)object2.get(1), new ProportionalBox(25, 27, 50, 22));
                        }
                        this.progressBar = new JProgressBar(0);
                        this.progressBar.setStringPainted(true);
                        this.applet.add((Component)this.progressBar, new ProportionalBox(5, 76, 90, 22));
                    }
                    catch (Throwable throwable) {
                        pse.util.general.Utilities.checkSwallow(throwable);
                    }
                    object2 = this.getParameter("backgroundcolor");
                    if (object2 != null && ((String)object2).length() > 0) {
                        try {
                            object = new Color(Integer.parseInt((String)object2, 16));
                            this.applet.setBackground((Color)object);
                            this.applet.getContentPane().setBackground((Color)object);
                            this.hideButton.setBackground(Color.LIGHT_GRAY);
                            this.showButton.setBackground(Color.LIGHT_GRAY);
                            this.progressBar.setBackground(this.applet.getBackground());
                        }
                        catch (Throwable throwable) {
                            pse.util.general.Utilities.checkIgnore(throwable);
                        }
                    }
                    this.pantherPkaUrlString = this.getParameter("pantherPkaURL");
                    this.pantherPreviousAutosaveXmlUrlString = this.getParameter("pantherPreviousAutosaveXmlURL");
                    this.reviewSessionId = this.getParameter("review-session-id");
                }
                if ((string2 = this.getParameter("autosaveintervalinmilliseconds")) != null && string2.trim().length() > 0) {
                    try {
                        this.autoSaveIntervalInMilliseconds = Integer.parseInt(string2);
                    }
                    catch (Throwable throwable) {
                        pse.util.general.Utilities.checkIgnore(throwable);
                    }
                }
                try {
                    string = this.getParameter("allowedptversions", "5.3.2;5.3.3;6.");
                    this.allowedPtVersions = string.split(";");
                }
                catch (Throwable throwable) {
                    pse.util.general.Utilities.check(throwable);
                    this.allowedPtVersions = Constants.ALLOWED_PT_VERSIONS;
                }
                try {
                    string = this.getParameter("disallowedptversions", "");
                    this.disallowedPtVersions = string == null || string.trim().length() == 0 ? new String[0] : string.split(";");
                }
                catch (Throwable throwable) {
                    pse.util.general.Utilities.check(throwable);
                    this.disallowedPtVersions = Constants.DISALLOWED_PT_VERSIONS;
                }
                string = this.getParameter("maxptverchecktime");
                if (string != null && string.trim().length() > 0) {
                    try {
                        this.maximumPacketTracerVersionCheckTimeInSeconds = Integer.parseInt(string);
                    }
                    catch (Throwable throwable) {
                        pse.util.general.Utilities.checkIgnore(throwable);
                    }
                }
                if ((object2 = this.getParameter("maxpkaloadtime")) != null && ((String)object2).trim().length() > 0) {
                    try {
                        this.maximumPkaLoadTimeInSeconds = Integer.parseInt((String)object2);
                    }
                    catch (Throwable throwable) {
                        pse.util.general.Utilities.checkIgnore(throwable);
                    }
                }
                this.minimumPtVersionSpecific = this.getParameter("minimumptversionspecific", Constants.MINIMUM_PT_VERSION_SPECIFIC_PARAMETER_DEFAULT);
                this.ptaLocation = this.getParameter("ptaplayerlocation", "extensions/ptaplayer");
                this.ptaAuthentication = this.getParameter("ptaplayerauthentication", "ptaplayer.pta");
                if (this.modeRavenna()) {
                    this.showButton.setEnabled(false);
                    this.hideButton.setEnabled(false);
                    this.applet.setVisible(true);
                    this.hideButton.setVisible(true);
                    this.showButton.setVisible(true);
                    this.progressBar.setVisible(true);
                    break block34;
                }
                try {
                    object = this.getParameter("ptmoids");
                    this.mediaObjectIds = object == null || ((String)object).trim().length() == 0 ? new String[0] : ((String)object).split(",");
                }
                catch (Throwable throwable) {
                    pse.util.general.Utilities.check(throwable);
                    this.mediaObjectIds = null;
                }
                this.xpass = new XPassPtsi(this.myId);
                this.xpass.initialize(this.applet, this.getParameter("message"));
                this.mode = this.xpass.getMode();
                if (this.modeAssessment()) {
                    this.xpass.register();
                }
            }
            catch (Throwable throwable) {
                this.handleTopLevelThrowable(throwable);
            }
        }
        Utilities.logPrintln("\n\n" + this + " INIT " + this.myId + " end \n\n");
    }

    @Override
    public void instanceCreation() {
        this.exceptionsOff = false;
        this.isActive = true;
        if (this.modeRavenna()) {
            this.applet.setVisible(false);
        }
    }

    @Override
    public boolean isActive() {
        return this.isActive;
    }

    @Override
    public void loadPTItem(String string) {
        try {
            String string2;
            this.exceptionsOff = false;
            if (this.modeAssessment() || this.modeRavenna()) {
                this.timersOn = false;
                this.createTimers();
                this.packetTracerWatcher = this.createPacketTracerWatcher();
                this.packetTracerWatcher.start();
            }
            this.updateStatus("loading");
            this.currentPtItemId = string;
            Result result = this.results.get(this.currentPtItemId);
            if (result == null && (string2 = this.getSessionXml(this.currentPtItemId)) != null) {
                result = this.initializeResult(this.currentPtItemId, string2);
                this.results.put(this.currentPtItemId, result);
            }
            int n = PacketTracer.findOpenIpcPort(39500);
            this.packetTracer = new PacketTracer("localhost", n, false);
            this.packetTracer.launch(this.applet.getLocator());
            this.packetTracer.connect();
            if (this.modeAssessment() || this.modeRavenna()) {
                this.packetTracer.disableInterface();
            }
            byte[] byArray = null;
            try {
                byArray = result.getLatestPkaBytes();
            }
            catch (Throwable throwable) {
                pse.util.general.Utilities.check(throwable);
                throw new ApplicationError.NoPka(throwable);
            }
            if (!this.packetTracer.loadBytes(byArray, "Assessment")) {
                throw new ApplicationError.PkaVersion();
            }
            this.updateStatus("loaded");
            if (this.modeAssessment() || this.modeRavenna()) {
                this.packetTracer.enableInterface();
                this.packetTracer.customizeInterfaceForMediaObject();
                result.getSession().fillInClientTime(Calendar.getInstance());
                this.timersOn = true;
                this.packetTracerWatcher.enable();
            }
            this.updateStatus("ready");
        }
        catch (Throwable throwable) {
            this.handleTopLevelThrowable(throwable);
        }
    }

    @Override
    public void performComplete() {
    }

    @Override
    public void performInterrupt() {
    }

    @Override
    public void performQuit() {
    }

    @Override
    public void performSystemCheck() {
        try {
            this.updateStatus("loading");
            int n = 1;
            int n2 = 8;
            if (this.modeRavenna()) {
                this.progressBar.setVisible(true);
                this.progressBar.setString("Initialization");
            }
            if (this.modeIip() || this.modeInitialization()) {
                if (this.mediaObjectIds != null) {
                    n2 += this.mediaObjectIds.length;
                }
            } else if (this.modeRavenna()) {
                ++n2;
            }
            this.checkBrowser();
            this.reportLoadingStatus("Locate Packet Tracer Installation Directory", n++, n2);
            if (!this.checkForPacketTracer()) {
                throw new PtsiWorkerError("XP-ERR-005");
            }
            this.reportLoadingStatus("Verify Packet Tracer Configuration", n++, n2);
            if (!this.checkPtaFile()) {
                throw new PtsiWorkerError("XP-ERR-008");
            }
            this.reportLoadingStatus("Determine Connection", n++, n2);
            int n3 = PacketTracer.findOpenIpcPort(39500);
            if (n3 <= 0) {
                throw new PtsiWorkerError("XP-ERR-004", "initialport", String.valueOf(39500));
            }
            this.packetTracer = new PacketTracer("localhost", n3, true);
            this.reportLoadingStatus("Start Packet Tracer", n++, n2);
            this.packetTracer.launch(this.applet.getLocator());
            this.reportLoadingStatus("Connect to Packet Tracer", n++, n2);
            this.packetTracer.connect();
            this.reportLoadingStatus("Check Packet Tracer Version", n++, n2);
            this.checkPacketTracerVersion();
            this.reportLoadingStatus("Close Packet Tracer", n++, n2);
            this.closePacketTracer();
            this.reportLoadingStatus("Download Assessment", n++, n2);
            if (this.modeIip() || this.modeInitialization()) {
                if (this.mediaObjectIds != null) {
                    for (String string : this.mediaObjectIds) {
                        String string2 = this.xpass.getMediaObjectXml(string);
                        PtsiStorage.addData(string, string2);
                        this.reportLoadingStatus("Finished", n++, n2);
                    }
                }
            } else if (this.modeRavenna()) {
                String string = this.getSessionXml(RAVENNA_PTMO_GUID);
                PtsiStorage.addData(RAVENNA_PTMO_GUID, string);
                this.reportLoadingStatus("Finished", n++, n2);
            }
            if (this.modeRavenna()) {
                pse.util.general.Utilities.guaranteedSleep(300L);
                this.progressBar.setVisible(false);
            }
            pse.util.general.Utilities.guaranteedSleep(1000L);
            this.updateStatus("loaded");
        }
        catch (Throwable throwable) {
            this.handleTopLevelThrowable(throwable);
        }
    }

    @Override
    public void setApplet(AbstractDelegatorApplet abstractDelegatorApplet) {
        this.applet = (PtsiApplet)abstractDelegatorApplet;
    }

    @Override
    public void start() {
        Utilities.logPrintln("\n\n" + this + " START " + this.myId + " start \n\n");
        this.exceptionsOff = false;
        this.isActive = true;
        if (this.modeRavenna()) {
            try {
                this.hideButton.setEnabled(false);
                this.hideButton.setVisible(false);
                this.hideButton.setVisible(true);
                this.hideButton.paintImmediately(this.hideButton.getVisibleRect());
            }
            catch (Throwable throwable) {
                pse.util.general.Utilities.checkSwallow(throwable);
            }
            try {
                this.showButton.setEnabled(true);
                this.showButton.setVisible(false);
                this.showButton.setVisible(true);
                this.showButton.paintImmediately(this.showButton.getVisibleRect());
            }
            catch (Throwable throwable) {
                pse.util.general.Utilities.checkSwallow(throwable);
            }
            try {
                this.progressBar.setVisible(false);
                this.progressBar.setVisible(true);
                this.progressBar.paintImmediately(this.progressBar.getVisibleRect());
            }
            catch (Throwable throwable) {
                pse.util.general.Utilities.checkSwallow(throwable);
            }
        }
        Utilities.logPrintln("\n\n" + this + " START " + this.myId + " end \n\n");
    }

    @Override
    public void stop() {
        Utilities.logPrintln("\n\n" + this + " STOP " + this.myId + " start \n\n");
        this.timersOn = false;
        this.exceptionsOff = true;
        this.isActive = false;
        if (this.modeRavenna()) {
            this.hideButton.setEnabled(false);
            this.showButton.setEnabled(false);
            if (this.progressBar != null) {
                this.progressBar.setVisible(false);
            }
        }
        this.unloadPTItem();
        if (this.packetTracer != null) {
            this.packetTracer.safeDestroyPacketTracerProcess();
        }
        Utilities.logPrintln("\n\n" + this + " STOP " + this.myId + " end \n\n");
    }

    @Override
    public void unloadPTItem() {
        try {
            this.destroyTimers();
            if (this.packetTracer != null && (this.modeAssessment() || this.modeRavenna())) {
                this.autoSave();
            }
            this.closePacketTracer();
        }
        catch (Throwable throwable) {
            this.handleTopLevelThrowable(throwable);
        }
    }

    public void updateStatus(String string) {
        this.applet.setStatus(string);
    }

    protected void autoSave() throws Throwable {
        String string = this.applet.getStatus();
        this.updateStatus("saving");
        Result result = this.results.get(this.currentPtItemId);
        IosLog iosLog = this.iosLogs.get(this.currentPtItemId);
        Session session = result.getSession();
        Calendar calendar = Calendar.getInstance();
        SittingEnd sittingEnd = new SittingEnd();
        sittingEnd.setClientTime(calendar);
        sittingEnd.setServerTimeForFillIn();
        IosLog iosLog2 = this.packetTracer.getIosLog(iosLog);
        byte[] byArray = this.packetTracer.extractBytes();
        result.noteAutoSave(byArray, iosLog2, Calendar.getInstance());
        session.addEvent(sittingEnd);
        String string2 = result.toXmlStringWithDocType();
        result.getWorkProduct().setIosLog(iosLog);
        session.removeEvent(sittingEnd);
        PtsiStorage.addData(this.currentPtItemId, string2);
        if (this.modeAssessment()) {
            try {
                this.xpass.putPtsiAutoSaveXml(this.currentPtItemId, string2);
            }
            catch (Throwable throwable) {
                this.reThrowXPassThrowable(throwable);
            }
        } else if (this.modeRavenna()) {
            // empty if block
        }
        this.updateStatus("saved");
        this.updateStatus(string);
    }

    protected void autoSaveElapsed(long l) {
        block8: {
            if (this.timersOn && (this.modeAssessment() || this.modeRavenna())) {
                if (!this.modeRavenna() && this.xpass.isInAutoSave()) {
                    Utilities.logPrintln("Older autosave in progress; current autosave is ignored");
                } else {
                    try {
                        if (this.modeRavenna() || this.xpassAvailable()) {
                            this.autoSave();
                        }
                    }
                    catch (ApplicationError.SaveGeneration saveGeneration) {
                        if (this.timersOn) {
                            Utilities.logPrintln("Autosave process ended by a later generation autosave");
                        }
                    }
                    catch (Throwable throwable) {
                        if (!this.timersOn) break block8;
                        this.handleTopLevelThrowable(throwable);
                    }
                }
            }
        }
    }

    protected boolean browserNameMatches(String string, String[] stringArray) {
        if (string == null || stringArray == null) {
            return false;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (!string.equalsIgnoreCase(stringArray[i])) continue;
            return true;
        }
        return false;
    }

    protected void checkBrowser() throws Exception {
        String string = this.applet.getParameter("browsername");
        Utilities.logPrintln("\t\tbrowserName = " + string);
        if (string == null || string.trim().length() == 0) {
            string = "Undetermined";
        }
        JreInfo.soleInstance().browserName().setValue(string);
        if (this.browserNameMatches(string, this.disallowedBrowserNames)) {
            JreInfo.soleInstance().browserName().setStatus(JreDatum.STATUS_ERROR, "Your browser (\"" + string + "\") <b>cannot</b> be used for Cisco Packet Tracer Skills Assessments!  We suggest you try Firefox or Internet Explorer instead.");
        }
    }

    protected boolean checkForPacketTracer() {
        try {
            PacketTracerLocator packetTracerLocator = this.applet.getLocator();
            return packetTracerLocator != null && packetTracerLocator.executableExists();
        }
        catch (Throwable throwable) {
            pse.util.general.Utilities.checkSwallow(throwable);
            return false;
        }
    }

    protected void checkPacketTracerVersion() {
        int n;
        int n2;
        SimpleBlock simpleBlock = new SimpleBlock(){

            public Object evaluate() throws Exception {
                return PtsiWorker.this.packetTracer.getVersion();
            }
        };
        GuaranteedActionStrict guaranteedActionStrict = new GuaranteedActionStrict("get packet tracer version", this.maximumPacketTracerVersionCheckTimeInSeconds * 1000, simpleBlock, true);
        guaranteedActionStrict.run();
        if (guaranteedActionStrict.timedOut()) {
            throw new PtsiWorkerError("XP-ERR-010");
        }
        if (!guaranteedActionStrict.isSuccessful()) {
            throw new PtsiWorkerError("XP-ERR-012");
        }
        String string = (String)guaranteedActionStrict.getReturnValue();
        if (string == null) {
            throw new PtsiWorkerError("XP-ERR-012");
        }
        JreInfo.soleInstance().ptVersion().setValue(string);
        Utilities.logPrintln("\n\nPT Version = <" + string + ">\n");
        for (n2 = 0; n2 < this.disallowedPtVersions.length; ++n2) {
            if (!string.startsWith(this.disallowedPtVersions[n2])) continue;
            throw new PtsiWorkerError("XP-ERR-012", "currentptversion", string);
        }
        n2 = 1;
        for (n = 0; n < this.allowedPtVersions.length; ++n) {
            if (!string.startsWith(this.allowedPtVersions[n])) continue;
            n2 = 0;
        }
        if (n2 != 0) {
            throw new PtsiWorkerError("XP-ERR-012", "currentptversion", string);
        }
        if (this.minimumPtVersionSpecific != null && this.minimumPtVersionSpecific.trim().length() > 0) {
            n = 0;
            if (PacketTracerUtils.getMajorVersion(string) < PacketTracerUtils.getMajorVersion(this.minimumPtVersionSpecific)) {
                n = 1;
            } else if (PacketTracerUtils.getMajorVersion(string) == PacketTracerUtils.getMajorVersion(this.minimumPtVersionSpecific)) {
                if (PacketTracerUtils.getMinorVersion(string) < PacketTracerUtils.getMinorVersion(this.minimumPtVersionSpecific)) {
                    n = 1;
                } else if (PacketTracerUtils.getMinorVersion(string) == PacketTracerUtils.getMinorVersion(this.minimumPtVersionSpecific) && PacketTracerUtils.getPatchVersion(string) < PacketTracerUtils.getPatchVersion(this.minimumPtVersionSpecific)) {
                    n = 1;
                }
            }
            if (n != 0) {
                throw new PtsiWorkerError("XP-ERR-028", "currentptversion", string, "requiredptversion", this.minimumPtVersionSpecific);
            }
        }
    }

    protected boolean checkPtaFile() {
        try {
            PacketTracerLocator packetTracerLocator = this.applet.getLocator();
            if (packetTracerLocator == null) {
                return false;
            }
            File file = packetTracerLocator.getHomeDirectory();
            if (file == null) {
                return false;
            }
            File file2 = new File(file, this.ptaLocation);
            if (file2 == null || !file2.exists() || !file2.isDirectory()) {
                return false;
            }
            File file3 = new File(file2, this.ptaAuthentication);
            return file3 != null && file3.exists();
        }
        catch (Throwable throwable) {
            pse.util.general.Utilities.checkSwallow(throwable);
            return false;
        }
    }

    protected void closePacketTracer() {
        this.packetTracerClosed = true;
        if (this.packetTracerWatcher != null) {
            this.packetTracerWatcher.halt();
        }
        if (this.packetTracer != null) {
            block6: {
                try {
                    this.packetTracer.shutDown();
                }
                catch (Throwable throwable) {
                    pse.util.general.Utilities.checkSwallow(throwable);
                    if (!this.modeRavenna()) break block6;
                    try {
                        this.packetTracer.enableClose();
                    }
                    catch (Throwable throwable2) {
                        pse.util.general.Utilities.check(throwable2);
                    }
                }
            }
            this.packetTracer.safeDestroyPacketTracerProcess();
            this.packetTracer = null;
            pse.util.general.Utilities.guaranteedSleep(3000L);
        }
    }

    protected WatcherThread createPacketTracerWatcher() {
        return new WatcherThread(){

            protected void checkAction() throws Exception {
                if (PtsiWorker.this.packetTracer != null && !PtsiWorker.this.packetTracer.testIfUp()) {
                    this.disable();
                    PtsiWorker.this.packetTracerClosed();
                }
            }
        };
    }

    protected void createTimers() {
        if (this.modeAssessment() || this.modeRavenna()) {
            if (this.autoSaveTimer != null) {
                this.autoSaveTimer.shouldStop();
            }
            this.autoSaveTimer = new NoTricksTimerThread(this.autoSaveIntervalInMilliseconds){

                public void doWork(long l) {
                    if (!this.stop) {
                        PtsiWorker.this.autoSaveElapsed(l);
                    }
                }
            };
            this.autoSaveTimer.setDaemon(true);
            this.autoSaveTimer.start();
        }
    }

    protected void destroyTimers() {
        if ((this.modeAssessment() || this.modeRavenna()) && this.autoSaveTimer != null) {
            try {
                this.autoSaveTimer.shouldStop();
            }
            catch (Throwable throwable) {
                pse.util.general.Utilities.check(throwable);
            }
            this.autoSaveTimer = null;
        }
    }

    protected byte[] getBytesFromRavennaUrl(URL uRL, String string) throws Exception {
        return Utilities.downloadBytes(uRL);
    }

    protected String getParameter(String string) {
        return this.applet.getParameter(string);
    }

    protected String getParameter(String string, String string2) {
        String string3 = this.getParameter(string);
        return string3 == null ? string2 : string3;
    }

    protected String getSessionXml(String string) {
        Object object;
        URL uRL;
        String string2 = PtsiStorage.getData(string);
        if (string2 != null || !this.modeRavenna()) {
            return string2;
        }
        if (StringUtils.nonEmpty(this.pantherPreviousAutosaveXmlUrlString)) {
            try {
                uRL = this.getUrl(this.pantherPreviousAutosaveXmlUrlString);
                object = this.getStringFromRavennaUrl(uRL, "attachment");
                if (object != null && ((String)object).trim().length() > 0) {
                    return object;
                }
            }
            catch (Throwable throwable) {
                ErrorUtils.checkSwallow(throwable);
            }
        }
        try {
            uRL = this.getUrl(this.pantherPkaUrlString);
            object = this.getBytesFromRavennaUrl(uRL, "attachment");
            Calendar calendar = Calendar.getInstance();
            Result result = new Result();
            Session session = result.getOrCreateSession();
            SessionStart sessionStart = new SessionStart();
            sessionStart.setClientTime(calendar);
            sessionStart.setServerTime(calendar);
            sessionStart.setTimeRemaining(0L);
            sessionStart.setTimeUsed(0L);
            session.addEvent(sessionStart);
            WorkProduct workProduct = result.getOrCreateWorkProduct();
            workProduct.setPkaContents((byte[])object);
            workProduct.setServerTime(calendar);
            SittingStart sittingStart = new SittingStart();
            sittingStart.setClientTime(calendar);
            sittingStart.setServerTime(calendar);
            sittingStart.setTimeRemaining(0L);
            sittingStart.setTimeUsed(0L);
            session.addEvent(sittingStart);
            WorkProductSummary workProductSummary = sittingStart.getWorkProductSummary();
            workProductSummary.setPkaContents((byte[])object);
            workProductSummary.setCommandSize(0);
            XpassSession xpassSession = sittingStart.getXpassSession();
            xpassSession.setId(this.reviewSessionId);
            xpassSession.setTimeLimit(0L);
            xpassSession.setTimeUsed(0L);
            return result.toXmlString();
        }
        catch (Throwable throwable) {
            throw new Error("Unable to create session XML", throwable);
        }
    }

    protected String getStringFromRavennaUrl(URL uRL, String string) throws Exception {
        byte[] byArray = Utilities.downloadBytes(uRL);
        String string2 = new String(byArray, "utf-8");
        return string2;
    }

    protected URL getUrl(String string) throws Exception {
        return new URL(this.applet.getDocumentBase(), string);
    }

    protected void handleTopLevelThrowable(Throwable throwable) {
        Utilities.logPrintln("Enter handleTopLevelThrowable on " + throwable);
        try {
            pse.util.general.Utilities.checkSwallow(throwable);
        }
        catch (Throwable throwable2) {
            Utilities.logPrintln("Error in checkSwallow: " + throwable2);
            pse.util.general.Utilities.check(throwable2);
        }
        if (this.exceptionsOff) {
            return;
        }
        String string = "";
        Map map = null;
        if (throwable instanceof PtsiWorkerError) {
            PtsiWorkerError ptsiWorkerError = (PtsiWorkerError)throwable;
            string = ptsiWorkerError.getErrorId();
            map = ptsiWorkerError.getInfoMap();
        } else {
            string = throwable instanceof PTSessionClosedError ? "XP-ERR-034" : (throwable instanceof XPassUnavailableException ? "XP-ERR-036" : (throwable instanceof ApplicationError.AppletOvertaken ? "XP-ERR-025" : (throwable instanceof ApplicationError.AssessmentComplete ? "XP-ERR-026" : (throwable instanceof ApplicationError.GetSessionXml ? "XP-ERR-024" : (throwable instanceof ApplicationError.IpcError ? "XP-ERR-002" : (throwable instanceof ApplicationError.NoIpcPort ? "XP-ERR-004" : (throwable instanceof ApplicationError.NoPka ? "XP-ERR-017" : (throwable instanceof ApplicationError.PacketTracerConnectTimeOut ? "XP-ERR-010" : (throwable instanceof ApplicationError.PacketTracerLaunch ? "XP-ERR-011" : (throwable instanceof ApplicationError.ParameterProcessing ? "XP-ERR-007" : (throwable instanceof ApplicationError.PkaVersion ? "XP-ERR-022" : (throwable instanceof ApplicationError.PutSessionXml ? "XP-ERR-035" : (throwable instanceof ApplicationError.SaveXmlCreation ? "XP-ERR-013" : (throwable instanceof ApplicationError.SaveXmlPosting ? "XP-ERR-014" : (throwable instanceof ApplicationError.SubmissionError ? "XP-ERR-015" : "XP-ERR-016")))))))))))))));
        }
        Utilities.logPrintln("\thandleTopLevelThrowable errorType = " + string);
        this.simpleError(string, throwable, map);
    }

    protected Result initializeResult(String string, String string2) throws Exception {
        Result result = new Result();
        try {
            result.read("Downloaded XML", string2);
        }
        catch (Throwable throwable) {
            throw new Error("Unable to parse session XML", throwable);
        }
        this.iosLogs.put(string, result.getOrCreateWorkProduct().getOrCreateIosLog());
        JreInfo jreInfo = JreInfo.soleInstance();
        SittingStart sittingStart = result.getSession().getLatestSittingStart();
        sittingStart.setBrowserName(jreInfo.browserName().getDynamicValue());
        sittingStart.setBrowserVersion(jreInfo.browserVersion().getDynamicValue());
        sittingStart.setOsName(jreInfo.osName().getDynamicValue());
        sittingStart.setOsVersion(jreInfo.osVersion().getDynamicValue());
        sittingStart.setPtHome(jreInfo.ptDirectory().getDynamicValue());
        sittingStart.setPtVersion(jreInfo.ptVersion().getDynamicValue());
        this.results.put(string, result);
        return result;
    }

    protected boolean modeAssessment() {
        return this.mode.equalsIgnoreCase("assessment");
    }

    protected boolean modeExamViewer() {
        return this.mode.equalsIgnoreCase("examviewer");
    }

    protected boolean modeIip() {
        return this.mode.equalsIgnoreCase("iip");
    }

    protected boolean modeIlf() {
        return this.mode.equalsIgnoreCase("ilf");
    }

    protected boolean modeInitialization() {
        return this.mode.equalsIgnoreCase("initialization");
    }

    protected boolean modeRavenna() {
        return this.mode.equalsIgnoreCase(RAVENNA_PTMO_GUID);
    }

    protected boolean packetTracerAvailable() {
        return this.packetTracer != null && !this.packetTracerClosed && this.packetTracer.isUp();
    }

    protected void packetTracerClosed() {
        if ((this.modeAssessment() || this.modeRavenna()) && this.timersOn && !this.packetTracerClosed) {
            this.timersOn = false;
            this.packetTracerClosed = true;
            this.simpleError("XP-ERR-034", null, null);
        }
    }

    protected void reportLoadingStatus(String string, int n, int n2) {
        if (this.modeRavenna()) {
            if (this.progressBar != null) {
                this.progressBar.setString(string);
                this.progressBar.setValue(n * 100 / n2);
            }
        } else {
            this.applet.loadingStatus(n, n2);
        }
    }

    protected void reThrowXPassThrowable(Throwable throwable) throws Throwable {
        pse.util.general.Utilities.check(throwable);
        if (throwable instanceof ApplicationError.AppletOvertaken || throwable instanceof ApplicationError.AssessmentComplete || throwable instanceof ApplicationError.SaveGeneration || throwable instanceof XPassUnavailableException) {
            throw throwable;
        }
        throw new XPassUnavailableException(throwable);
    }

    protected void simpleError(String string, Throwable throwable, Map<String, String> map) {
        this.closePacketTracer();
        if (this.modeAssessment()) {
            try {
                this.xpass.reportGeneralError(this.applet.getDocumentBase(), string, throwable, map);
            }
            catch (Throwable throwable2) {
                pse.util.general.Utilities.check(throwable2);
            }
        } else if (this.modeRavenna()) {
            this.applet.goToErrorPage("Error: " + string, ErrorUtils.errorString(throwable));
            return;
        }
        this.applet.throwError(string);
    }

    protected boolean xpassAvailable() {
        return this.xpass != null && this.xpass.isUp();
    }

    protected void xpassUnavailable(Throwable throwable) {
        if (this.modeAssessment()) {
            this.timersOn = false;
            this.closePacketTracer();
            this.applet.throwError("XP-ERR-036");
        }
    }
}

